/*
 * Decompiled with CFR 0.152.
 */
package helper2025;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

class TileManager {
    private final Map<Character, BufferedImage> tiles;
    private final BufferedImage percorsoTile;
    private final int tileSize;

    public TileManager(String tilesPath, int tileSize) {
        this.tileSize = tileSize;
        this.tiles = new HashMap<Character, BufferedImage>();
        try {
            this.tiles.put(Character.valueOf('I'), ImageIO.read(new File(tilesPath + "/ingresso.png")));
            this.tiles.put(Character.valueOf('U'), ImageIO.read(new File(tilesPath + "/uscita.png")));
            this.tiles.put(Character.valueOf('b'), ImageIO.read(new File(tilesPath + "/bomba.png")));
            this.tiles.put(Character.valueOf('P'), ImageIO.read(new File(tilesPath + "/pozione.png")));
            this.tiles.put(Character.valueOf('_'), ImageIO.read(new File(tilesPath + "/vuoto.png")));
            this.percorsoTile = ImageIO.read(new File(tilesPath + "/percorso.png"));
            System.out.println("Tile caricate con successo!");
        }
        catch (IOException e) {
            throw new RuntimeException("Errore nel caricare le tile: " + e.getMessage());
        }
    }

    public BufferedImage getTile(char tipo) {
        return this.tiles.getOrDefault(Character.valueOf(tipo), this.tiles.get(Character.valueOf('_')));
    }

    public BufferedImage getPercorsoTile() {
        return this.percorsoTile;
    }

    public int getTileSize() {
        return this.tileSize;
    }
}

