/*
 * Decompiled with CFR 0.152.
 */
package helper2025;

import helper2025.Labirinto;
import helper2025.Posizione;
import helper2025.TestCase;
import helper2025.TileManager;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;

public class Helper {
    private static Random generatore = new Random();
    private static final int DURATA_IMMUNITA = 3;
    private static final int MIN_DISTANZA_BOMBA_INIZIO = 5;
    private static final int DISTANZA_MINIMA_USCITA = 4;
    private static final int MIN_RIGHE = 5;
    private static final int MAX_RIGHE = 50;
    private static final int MIN_COLONNE = 5;
    private static final int MAX_COLONNE = 50;
    private static final int MAX_RAND_BOMBE = 3;
    private static final int BOMBE_SUL_PERCORSO = 2;
    private static final int MAX_TENTATIVI_POSIZIONAMENTO = 100;
    private static final int NUM_ELEMENTI_FUORI_PERCORSO = 2;
    private static final int POS_CASUALI_INIZIO = 3;
    private static final int POS_CASUALI_FINE = 5;
    private static final int MAX_MOSSE_EXTRA = 5;
    private static final int FALLIMENTO = -1000000;
    private List<Posizione> percorso;
    private TileManager tileManager;

    public void setSeed(long seed) {
        generatore = new Random(seed);
    }

    public TestCase generaTest() {
        int righe = 5 + generatore.nextInt(50);
        int colonne = 5 + generatore.nextInt(50);
        int uscitaX = 4 + generatore.nextInt(colonne - 4);
        int uscitaY = 4 + generatore.nextInt(righe - 4);
        int multiplier = righe * colonne / 100;
        String mosse = this.generaMosse(new Posizione(0, 0), new Posizione(uscitaX, uscitaY), righe, colonne, 5);
        this.percorso = this.calcolaPercorso(mosse, righe, colonne);
        Labirinto labirinto = new Labirinto(righe, colonne);
        boolean risolvibile = generatore.nextBoolean();
        int risultato = risolvibile ? this.configuraRisolvibile(labirinto, this.percorso) : this.configuraNonRisolvibile(labirinto, this.percorso);
        this.posizionaFuoriPercorso(labirinto, this.percorso, 'b', 2 * multiplier);
        this.posizionaFuoriPercorso(labirinto, this.percorso, 'P', 2 * multiplier);
        return new TestCase(labirinto.copiaMappa(), mosse);
    }

    public boolean testSoluzione(int punti, TestCase t) {
        int x = 0;
        int y = 0;
        String percorso = t.getMosse();
        char[][] mappa = t.getMappa();
        int maxX = mappa[0].length;
        int maxY = mappa.length;
        int invincibile = 0;
        int risultato = 0;
        int i = 0;
        while (i < percorso.length()) {
            char mossa = percorso.charAt(i);
            if (mossa == 'S') {
                --x;
            } else if (mossa == 'D') {
                ++x;
            } else if (mossa == 'A') {
                --y;
            } else if (mossa == 'B') {
                ++y;
            }
            if (x < 0 || x >= maxX) {
                risultato = -1000000;
                break;
            }
            if (y < 0 || y >= maxY) {
                risultato = -1000000;
                break;
            }
            ++risultato;
            char cella = mappa[y][x];
            if (cella == '_' || cella == 'I') {
                if (invincibile > 0) {
                    --invincibile;
                }
            } else if (cella == 'b') {
                if (invincibile == 0) {
                    risultato = -1000000;
                    break;
                }
                mappa[y][x] = 95;
                --invincibile;
                risultato -= 2;
            } else if (cella == 'P') {
                invincibile = 3;
                mappa[y][x] = 95;
                risultato += 3;
            } else if (cella == 'U') break;
            ++i;
        }
        if (risultato != -1000000 && mappa[y][x] != 'U') {
            risultato = -1000000;
        }
        System.out.println("punteggio proposto " + punti);
        System.out.println("punteggio corretto " + risultato);
        System.out.println("--------------------");
        return punti == risultato;
    }

    private List<Posizione> calcolaPercorso(String mosse, int righe, int colonne) {
        ArrayList<Posizione> percorso = new ArrayList<Posizione>();
        int x = 0;
        int y = 0;
        percorso.add(new Posizione(x, y));
        char[] cArray = mosse.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char mossa = cArray[n2];
            int nuovoX = x;
            int nuovoY = y;
            switch (mossa) {
                case 'A': {
                    --nuovoY;
                    break;
                }
                case 'B': {
                    ++nuovoY;
                    break;
                }
                case 'S': {
                    --nuovoX;
                    break;
                }
                case 'D': {
                    ++nuovoX;
                }
            }
            if (nuovoX < 0 || nuovoX >= colonne || nuovoY < 0 || nuovoY >= righe) break;
            x = nuovoX;
            y = nuovoY;
            percorso.add(new Posizione(x, y));
            ++n2;
        }
        return percorso;
    }

    private int configuraRisolvibile(Labirinto labirinto, List<Posizione> percorso) {
        int posBomba;
        Object pBomba;
        if (percorso.isEmpty()) {
            throw new IllegalArgumentException("Il percorso non pub essere vuoto per un labirinto risolvibile.");
        }
        if (percorso.size() <= 5) {
            Posizione uscita = percorso.get(percorso.size() - 1);
            labirinto.popolaCella(uscita.y, uscita.x, 'U');
            return percorso.size() - 1;
        }
        Posizione uscita = percorso.get(percorso.size() - 1);
        labirinto.popolaCella(uscita.y, uscita.x, 'U');
        int numBombe = 1 + generatore.nextInt(3);
        ArrayList<Integer> posizioniBombe = new ArrayList<Integer>();
        int i = 0;
        while (i < numBombe) {
            int tentativi = 0;
            do {
                posBomba = 5 + generatore.nextInt(percorso.size() - 5);
                pBomba = percorso.get(posBomba);
            } while (++tentativi <= 100 && (labirinto.getCella(((Posizione)pBomba).y, ((Posizione)pBomba).x) != '_' || posizioniBombe.contains(posBomba)));
            posizioniBombe.add(percorso.indexOf(pBomba));
            labirinto.popolaCella(((Posizione)pBomba).y, ((Posizione)pBomba).x, 'b');
            ++i;
        }
        ArrayList<Posizione> posizioniPozioni = new ArrayList<Posizione>();
        pBomba = posizioniBombe.iterator();
        block2: while (pBomba.hasNext()) {
            posBomba = (Integer)pBomba.next();
            boolean posizioneValida = false;
            int tentativi = 0;
            while (!posizioneValida) {
                int posPozione = Math.max(1, posBomba - (1 + generatore.nextInt(3)));
                Posizione pPozione = percorso.get(posPozione);
                if (++tentativi > 100) continue block2;
                if (labirinto.getCella(pPozione.y, pPozione.x) == 'b') continue;
                labirinto.popolaCella(pPozione.y, pPozione.x, 'P');
                posizioniPozioni.add(pPozione);
                posizioneValida = true;
            }
        }
        int numBombePosizionate = posizioniBombe.size();
        int numPozioniPosizionate = posizioniPozioni.size();
        return percorso.size() + 3 * numPozioniPosizionate - 2 * numBombePosizionate;
    }

    private int configuraNonRisolvibile(Labirinto lab, List<Posizione> percorso) {
        if (percorso.isEmpty()) {
            return -1;
        }
        int tipoSconfitta = generatore.nextInt(3);
        switch (tipoSconfitta) {
            case 0: {
                return this.mettiBombaSulPercorso(lab, percorso);
            }
            case 1: {
                return this.mettiBombaDopoImmunitaScaduta(lab, percorso);
            }
            case 2: {
                return this.mettiUscitaIrraggiungibile(lab, percorso);
            }
        }
        return -1;
    }

    private int mettiBombaSulPercorso(Labirinto lab, List<Posizione> percorso) {
        if (percorso.size() <= 5) {
            Posizione uscita = percorso.get(percorso.size() - 2);
            lab.popolaCella(uscita.y, uscita.x, 'b');
            return -1;
        }
        int i = 0;
        while (i < 2) {
            int posBomba = 5 + generatore.nextInt(percorso.size() - 5);
            Posizione p = percorso.get(posBomba);
            lab.popolaCella(p.y, p.x, 'b');
            if (posBomba + 3 < percorso.size()) {
                Posizione uscita = percorso.get(percorso.size() - 1);
                lab.popolaCella(uscita.y, uscita.x, 'U');
            }
            ++i;
        }
        return -1;
    }

    private int mettiBombaDopoImmunitaScaduta(Labirinto lab, List<Posizione> percorso) {
        if (percorso.size() < 7) {
            return this.mettiBombaSulPercorso(lab, percorso);
        }
        Posizione pozione = percorso.get(1);
        lab.popolaCella(pozione.y, pozione.x, 'P');
        int posBomba = 5 + generatore.nextInt(Math.min(5, percorso.size() - 5));
        Posizione bomba = percorso.get(posBomba);
        lab.popolaCella(bomba.y, bomba.x, 'b');
        Posizione uscita = percorso.get(percorso.size() - 1);
        lab.popolaCella(uscita.y, uscita.x, 'U');
        return -1;
    }

    private int mettiUscitaIrraggiungibile(Labirinto lab, List<Posizione> percorso) {
        int y;
        int x;
        Posizione uscita;
        int righe = lab.righe();
        int colonne = lab.colonne();
        while (percorso.contains(uscita = new Posizione(x = generatore.nextInt(colonne), y = generatore.nextInt(righe)))) {
        }
        lab.popolaCella(uscita.y, uscita.x, 'U');
        return -1;
    }

    private String generaMosse(Posizione ingresso, Posizione uscita, int righe, int colonne, int maxMosseExtra) {
        StringBuilder mosse = new StringBuilder();
        int x = ingresso.x;
        int y = ingresso.y;
        while (x != uscita.x || y != uscita.y) {
            int deltaX = uscita.x - x;
            int deltaY = uscita.y - y;
            if (x < 0 || x >= colonne || y < 0 || y >= righe) {
                System.out.println("ERRORE: percorso base uscito dai bounds!");
                throw new IllegalStateException("Uscita dai bounds durante la generazione delle mosse.");
            }
            ArrayList<Character> mosseValide = new ArrayList<Character>();
            if (deltaX > 0) {
                mosseValide.add(Character.valueOf('D'));
            }
            if (deltaX < 0) {
                mosseValide.add(Character.valueOf('S'));
            }
            if (deltaY > 0) {
                mosseValide.add(Character.valueOf('B'));
            }
            if (deltaY < 0) {
                mosseValide.add(Character.valueOf('A'));
            }
            char mossa = ((Character)mosseValide.get(generatore.nextInt(mosseValide.size()))).charValue();
            mosse.append(mossa);
            switch (mossa) {
                case 'A': {
                    --y;
                    break;
                }
                case 'B': {
                    ++y;
                    break;
                }
                case 'S': {
                    --x;
                    break;
                }
                case 'D': {
                    ++x;
                }
            }
        }
        if (mosse.length() > 8) {
            int i = 0;
            while (i < maxMosseExtra) {
                int pos = 3 + generatore.nextInt(mosse.length() - 8);
                int currX = ingresso.x;
                int currY = ingresso.y;
                int j = 0;
                while (j < pos) {
                    char m = mosse.charAt(j);
                    switch (m) {
                        case 'A': {
                            --currY;
                            break;
                        }
                        case 'B': {
                            ++currY;
                            break;
                        }
                        case 'S': {
                            --currX;
                            break;
                        }
                        case 'D': {
                            ++currX;
                        }
                    }
                    ++j;
                }
                char direzione = "ABSD".charAt(generatore.nextInt(4));
                int testX = currX;
                int testY = currY;
                switch (direzione) {
                    case 'A': {
                        --testY;
                        break;
                    }
                    case 'B': {
                        ++testY;
                        break;
                    }
                    case 'S': {
                        --testX;
                        break;
                    }
                    case 'D': {
                        ++testX;
                    }
                }
                if (testX >= 0 && testX < colonne && testY >= 0 && testY < righe) {
                    char opposta = this.direzioneOpposta(direzione);
                    mosse.insert(pos, "" + direzione + opposta);
                }
                ++i;
            }
        }
        return mosse.toString();
    }

    private char direzioneOpposta(char dir) {
        switch (dir) {
            case 'A': {
                return 'B';
            }
            case 'B': {
                return 'A';
            }
            case 'S': {
                return 'D';
            }
            case 'D': {
                return 'S';
            }
        }
        return dir;
    }

    private void posizionaFuoriPercorso(Labirinto lab, List<Posizione> percorso, char tipo, int quantita) {
        int righe = lab.righe();
        int colonne = lab.colonne();
        int i = 0;
        while (i < quantita) {
            int y;
            int x = generatore.nextInt(colonne);
            Posizione p = new Posizione(x, y = generatore.nextInt(righe));
            if (!percorso.contains(p) && lab.getCella(y, x) == '_') {
                lab.popolaCella(p.y, p.x, tipo);
            }
            ++i;
        }
    }

    public void stampaLabirinto(char[][] mappa) {
        System.out.println();
        int i = 0;
        while (i < mappa.length) {
            int j = 0;
            while (j < mappa[i].length) {
                if (this.percorso.contains(new Posizione(j, i))) {
                    System.out.print('*');
                } else {
                    System.out.print('_');
                }
                System.out.print(mappa[i][j]);
                System.out.print('|');
                ++j;
            }
            System.out.println();
            ++i;
        }
        System.out.println("Legenda: ");
        System.out.println("I=Ingresso, U=Uscita,");
        System.out.println("b=Bomba, P=Pozione, _=Spazio Vuoto");
    }

    public void inizializzaTiles(String tilesPath, int tileSize) {
        this.tileManager = new TileManager(tilesPath, tileSize);
    }

    public void generaImmagineLabirinto(char[][] griglia, String outputPath) {
        if (this.tileManager == null) {
            throw new IllegalStateException("helper2025.TileManager non inizializzato!");
        }
        int righe = griglia.length;
        int colonne = griglia[0].length;
        int tileSize = this.tileManager.getTileSize();
        int margin = 10;
        int width = colonne * tileSize + 2 * margin;
        int height = righe * tileSize + 2 * margin;
        BufferedImage immagine = new BufferedImage(width, height, 2);
        Graphics2D g = immagine.createGraphics();
        g.setColor(new Color(40, 40, 40));
        g.fillRect(0, 0, width, height);
        int i = 0;
        while (i < righe) {
            int j = 0;
            while (j < colonne) {
                char cella;
                int x = j * tileSize + margin;
                int y = i * tileSize + margin;
                if (this.percorso != null && this.percorso.contains(new Posizione(j, i))) {
                    g.drawImage(this.tileManager.getPercorsoTile(), x, y, tileSize, tileSize, null);
                }
                if ((cella = griglia[i][j]) != '_' || this.percorso == null || !this.percorso.contains(new Posizione(j, i))) {
                    BufferedImage tile = this.tileManager.getTile(cella);
                    g.drawImage(tile, x, y, tileSize, tileSize, null);
                }
                ++j;
            }
            ++i;
        }
        g.setColor(new Color(100, 100, 100, 128));
        i = 0;
        while (i <= righe) {
            int y = i * tileSize + margin;
            g.drawLine(margin, y, colonne * tileSize + margin, y);
            ++i;
        }
        int j = 0;
        while (j <= colonne) {
            int x = j * tileSize + margin;
            g.drawLine(x, margin, x, righe * tileSize + margin);
            ++j;
        }
        g.dispose();
        try {
            ImageIO.write((RenderedImage)immagine, "PNG", new File(outputPath));
            System.out.println("\u2713 Immagine salvata: " + outputPath);
        }
        catch (IOException e) {
            System.err.println("\u2717 Errore: " + e.getMessage());
        }
    }
}

